use 02_rep.dta

merge using dl_os_fc.dta


* a. Graph dependent variable
line fadopt date
graph save figure1.gph, replace
*graph export figure1.eps, replace

* b. Make out-of-sample forecast graph
label variable fadopt "Observed"
label variable y_fc_ws "ARMA prediction"
label variable dl_os_fc "TM prediction"

local b=551
local c=584
twoway (line fadopt date,lcolor(gs0) lwidth(medium)) (line y_fc_ws date, lcolor(gs0) lpattern(dash)) (line dl_os_fc date,lpattern(dash)) if date>`b' & date<`c', graphregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) ylabel(#6,nogrid) ytitle("Number of acts adopted") title("") tline(573) xlabel(#12, labsize(small) alternate) xtitle("")  

graph save figure2.gph, replace
*graph export figure2.eps, replace

* c. Make real-time forecast (date>584 ; 2008m9)
label variable y_fc_os "ARMA real-time forecast"
label variable dl_os_fc "TM real-time forecast"
twoway (line fadopt date,lcolor(gs0) lwidth(medium)) (line y_fc_os date, lcolor(gs0) lpattern(dash)) (line dl_os_fc date,lpattern(dash))  if date>`c'-24, graphregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) ylabel(#6, nogrid) ytitle("Number of acts adopted") title("") tline(584) xlabel(#12, labsize(small) alternate) xtitle("") 
graph save figure3.gph, replace
*graph export figure3.eps, replace

exit